<?php

namespace Tests\Browser\Modules\ShippingMethod;

use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\File;
use Laravel\Dusk\Browser;
use Modules\Shipping\Entities\ShippingMethod;
use Tests\DuskTestCase;

class ShippingMethodTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $methods = ShippingMethod::where('id', '>', 2)->get();
        foreach($methods as $method){
            if(File::exists(public_path($method->logo)) && $method->logo != null){
                File::delete(public_path($method->logo));
            }
            $method->delete();
        }

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            
            $browser->loginAs(1)
                    ->visit('/setup/shipping-methods')
                    ->assertSee('Shipping Method');
        });
    }

    public function test_for_create_shipping_method(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#method_name', 'test-shipping-method')
                ->type('#phone', $this->faker->phoneNumber)
                ->type('#shipment_time', '3-5 days')
                ->type('#cost', '20')
                ->attach('#thumbnail_logo', __DIR__.'/files/favicon.png')
                ->click('#createForm > div > div > div.col-lg-12.text-center > button')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!');
        });
    }

    public function test_for_validate_create_shipping_method(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#method_name', '')
                ->type('#phone', '')
                ->type('#shipment_time', '')
                ->type('#cost', '')
                ->click('#createForm > div > div > div.col-lg-12.text-center > button')
                ->pause(1000)
                ->waitForTextIn('#error_shipment_time', 'Format must be like 3-5 days or 3-5 hrs',25)
                ->type('#shipment_time', '3-5 days')
                ->click('#createForm > div > div > div.col-lg-12.text-center > button')
                ->pause(1000)
                ->waitForTextIn('#error_method_name', 'The method name field is required.',25)
                ->waitForTextIn('#error_phone', 'The phone field is required.',25)
                ->waitForTextIn('#error_cost', 'The cost field is required.',25);

        });
    }

    public function test_for_edit_shipping_method(){
        $this->test_for_create_shipping_method();
        $this->browse(function (Browser $browser) {
            $browser->waitForTextIn('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(3)', 'test-shipping-method', 25)
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > th')
                ->click('#DataTables_Table_1 > tbody > tr.child > td > ul > li:nth-child(2) > span.dtr-data > div > button')
                ->click('#DataTables_Table_1 > tbody > tr.child > td > ul > li:nth-child(2) > span.dtr-data > div > div > a.dropdown-item.edit_method')
                ->waitForTextIn('#main-content > section > div > div > div.col-lg-4 > div > div > div > h3', 'Edit Method Info', 25)
                ->type('#method_name', 'test-shipping-method-edit')
                ->type('#phone', $this->faker->phoneNumber)
                ->type('#shipment_time', '5-8 days')
                ->type('#cost', '15')
                ->attach('#thumbnail_logo', __DIR__.'/files/favicon.png')
                ->click('#methodEditForm > div > div > div.col-lg-12.text-center > button')
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_validate_edit_shipping_method(){
        $this->test_for_create_shipping_method();
        $this->browse(function (Browser $browser) {
            $browser->waitForTextIn('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(3)', 'test-shipping-method', 25)
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > th')
                ->click('#DataTables_Table_1 > tbody > tr.child > td > ul > li:nth-child(2) > span.dtr-data > div > button')
                ->click('#DataTables_Table_1 > tbody > tr.child > td > ul > li:nth-child(2) > span.dtr-data > div > div > a.dropdown-item.edit_method')
                ->waitForTextIn('#main-content > section > div > div > div.col-lg-4 > div > div > div > h3', 'Edit Method Info', 25)
                ->type('#method_name', '')
                ->type('#phone', '')
                ->type('#shipment_time', '')
                ->type('#cost', '')
                ->click('#methodEditForm > div > div > div.col-lg-12.text-center > button')
                ->pause(2000)
                ->waitForTextIn('#error_shipment_time', 'Format must be like 3-5 days or 3-5 hrs',25)
                ->type('#shipment_time', '3-5 days')
                ->pause(1000)
                ->click('#methodEditForm > div > div > div.col-lg-12.text-center > button')
                ->pause(1000)
                ->waitForTextIn('#error_method_name', 'The method name field is required.',25)
                ->waitForTextIn('#error_phone', 'The phone field is required.',25)
                ->waitForTextIn('#error_cost', 'The cost field is required.',25);

        });
    }

    public function test_for_delete_shipping_method(){
        $this->test_for_create_shipping_method();
        $this->browse(function (Browser $browser) {
            $browser->waitForTextIn('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(3)', 'test-shipping-method', 25)
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > th')
                ->click('#DataTables_Table_1 > tbody > tr.child > td > ul > li:nth-child(2) > span.dtr-data > div > button')
                ->click('#DataTables_Table_1 > tbody > tr.child > td > ul > li:nth-child(2) > span.dtr-data > div > div > a.dropdown-item.delete_method')
                ->whenAvailable('#shipping_delete_form', function($modal){
                    $modal->click('#dataDeleteBtn');
                })
                ->pause(7000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');
        });
    }

    public function test_for_update_status(){
        $this->test_for_create_shipping_method();
        $this->browse(function (Browser $browser) {
            $browser->waitForTextIn('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(3)', 'test-shipping-method', 25)
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(4) > label > div')
                ->pause(7000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_approve_status_update(){
        $this->test_for_create_shipping_method();
        $this->browse(function (Browser $browser) {
            $browser->waitForTextIn('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(3)', 'test-shipping-method', 25)
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(5) > label > div')
                ->pause(6000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });    
    }
    

}
