<?php

namespace Tests\Browser\Modules\GeneralSetting;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Modules\GeneralSetting\Entities\Currency;
use Tests\DuskTestCase;

class CurrencyTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $currencies = Currency::where('id', '>', 120)->pluck('id');
        if(count($currencies) > 0){
            Currency::destroy($currencies);
        }


        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                    ->visit('/setup/currencies')
                    ->assertSee('Currency List');
        });
    }

    public function test_for_add_currency(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-12 > div > div > ul > li > a')
                ->whenAvailable('#currency_addForm', function($modal){
                    $modal->type('div > div:nth-child(1) > div > input', 'test-currency')
                        ->type('div > div:nth-child(2) > div > input', $this->faker->name)
                        ->type('div > div:nth-child(3) > div > input', '$')
                        ->type('div > div:nth-child(4) > div > input', '20')
                        ->click('div > div.col-lg-12.text-center > div > button')
                        ->assertPathIs('/setup/currencies');
                }, 5)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Added successfully!');
        });
        
    }

    public function test_for_edit_currency(){
        $this->test_for_add_currency();
        $this->browse(function (Browser $browser) {
            $browser->type('#DataTables_Table_0_filter > label > input[type=search]', 'test-currency')
                ->pause(2000)
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(7) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(7) > div > div > a')
                ->whenAvailable('#currencyEditForm', function($modal){
                    $modal->type('div > div:nth-child(1) > div > input', $this->faker->name)
                        ->type('div > div:nth-child(2) > div > input', $this->faker->name)
                        ->type('div > div:nth-child(3) > div > input', '$')
                        ->type('div > div:nth-child(4) > div > input', '30')
                        ->click('div > div.col-lg-12.text-center > div > button')
                        ->assertPathIs('/setup/currencies');
                }, 25)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');

        });
        
    }

    public function test_for_delete_currency(){
        $this->test_for_add_currency();
        $this->browse(function (Browser $browser) {
            $browser->type('#DataTables_Table_0_filter > label > input[type=search]', 'test-currency')
                ->pause(2000)
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(7) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(7) > div > div > a.dropdown-item.delete_currency')
                ->whenAvailable('#confirm-delete > div > div > div.modal-body > div.mt-40.d-flex.justify-content-between', function($modal){
                    $modal->click('#delete_link')
                        ->assertPathIs('/setup/currencies');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');


        });        
    }

    public function test_for_status_change(){
        $this->test_for_add_currency();
        $this->browse(function (Browser $browser) {
            $browser->type('#DataTables_Table_0_filter > label > input[type=search]', 'test-currency')
                ->pause(2000)
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(5) > label > div')
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }
}