<?php

namespace Modules\Setup\Http\Controllers\API;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Setup\Entities\AlgoliaSearchConfiguration;
use Modules\Setup\Services\CountryService;
use Modules\Setup\Services\SetupService;

class SetupController extends Controller
{
    protected $setupService;

    public function __construct(SetupService $setupService)
    {
        $this->setupService = $setupService;
    }

    public function algoliaSearchConfig()
    {
        $algoliaSearch = AlgoliaSearchConfiguration::first();
        return response()->json([
            'algoliaSearch' => $algoliaSearch,
            'message' => 'success'
        ]);
    }

    public function updateAlgoliaSearchConfig(Request $request)
    {
        $status = $request->status;
        $algoliaSearch = $this->setupService->updateAlgoliaSearchConfig($status);
        
        if($algoliaSearch){
            return response()->json([
                'message' => 'success'
            ], 200);
        }else{
            return response()->json([
                'message' => 'error'
            ], 500);
        }
    }
}
