<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\Rest\Wireless\V1;

/**
 * @property \Twilio\Rest\Wireless\V1 $v1
 * @property \Twilio\Rest\Wireless\V1\UsageRecordList $usageRecords
 * @property \Twilio\Rest\Wireless\V1\CommandList $commands
 * @property \Twilio\Rest\Wireless\V1\RatePlanList $ratePlans
 * @property \Twilio\Rest\Wireless\V1\SimList $sims
 * @method \Twilio\Rest\Wireless\V1\CommandContext commands(string $sid)
 * @method \Twilio\Rest\Wireless\V1\RatePlanContext ratePlans(string $sid)
 * @method \Twilio\Rest\Wireless\V1\SimContext sims(string $sid)
 */
class Wireless extends Domain {
    protected $_v1;

    /**
     * Construct the Wireless Domain
     *
     * @param Client $client Client to communicate with Twilio
     */
    public function __construct(Client $client) {
        parent::__construct($client);

        $this->baseUrl = 'https://wireless.twilio.com';
    }

    /**
     * @return V1 Version v1 of wireless
     */
    protected function getV1(): V1 {
        if (!$this->_v1) {
            $this->_v1 = new V1($this);
        }
        return $this->_v1;
    }

    /**
     * Magic getter to lazy load version
     *
     * @param string $name Version to return
     * @return \Twilio\Version The requested version
     * @throws TwilioException For unknown versions
     */
    public function __get(string $name) {
        $method = 'get' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown version ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return \Twilio\InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments) {
        $method = 'context' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return \call_user_func_array([$this, $method], $arguments);
        }

        throw new TwilioException('Unknown context ' . $name);
    }

    protected function getUsageRecords(): \Twilio\Rest\Wireless\V1\UsageRecordList {
        return $this->v1->usageRecords;
    }

    protected function getCommands(): \Twilio\Rest\Wireless\V1\CommandList {
        return $this->v1->commands;
    }

    /**
     * @param string $sid The SID that identifies the resource to fetch
     */
    protected function contextCommands(string $sid): \Twilio\Rest\Wireless\V1\CommandContext {
        return $this->v1->commands($sid);
    }

    protected function getRatePlans(): \Twilio\Rest\Wireless\V1\RatePlanList {
        return $this->v1->ratePlans;
    }

    /**
     * @param string $sid The SID that identifies the resource to fetch
     */
    protected function contextRatePlans(string $sid): \Twilio\Rest\Wireless\V1\RatePlanContext {
        return $this->v1->ratePlans($sid);
    }

    protected function getSims(): \Twilio\Rest\Wireless\V1\SimList {
        return $this->v1->sims;
    }

    /**
     * @param string $sid The SID of the Sim resource to fetch
     */
    protected function contextSims(string $sid): \Twilio\Rest\Wireless\V1\SimContext {
        return $this->v1->sims($sid);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Wireless]';
    }
}