<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Verify\V2;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
class SafelistContext extends InstanceContext {
    /**
     * Initialize the SafelistContext
     *
     * @param Version $version Version that contains the resource
     * @param string $phoneNumber The phone number to be fetched from SafeList.
     */
    public function __construct(Version $version, $phoneNumber) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['phoneNumber' => $phoneNumber, ];

        $this->uri = '/SafeList/Numbers/' . \rawurlencode($phoneNumber) . '';
    }

    /**
     * Fetch the SafelistInstance
     *
     * @return SafelistInstance Fetched SafelistInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): SafelistInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new SafelistInstance($this->version, $payload, $this->solution['phoneNumber']);
    }

    /**
     * Delete the SafelistInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->version->delete('DELETE', $this->uri);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Verify.V2.SafelistContext ' . \implode(' ', $context) . ']';
    }
}