<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\FlexApi\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class InsightsQuestionnairesQuestionOptions {
    /**
     * @param string $token The Token HTTP request header
     * @return CreateInsightsQuestionnairesQuestionOptions Options builder
     */
    public static function create(string $token = Values::NONE): CreateInsightsQuestionnairesQuestionOptions {
        return new CreateInsightsQuestionnairesQuestionOptions($token);
    }

    /**
     * @param string $categoryId Category ID
     * @param string $question The question.
     * @param string $description The question description.
     * @param string $answerSetId The answer_set for question.
     * @param string $token The Token HTTP request header
     * @return UpdateInsightsQuestionnairesQuestionOptions Options builder
     */
    public static function update(string $categoryId = Values::NONE, string $question = Values::NONE, string $description = Values::NONE, string $answerSetId = Values::NONE, string $token = Values::NONE): UpdateInsightsQuestionnairesQuestionOptions {
        return new UpdateInsightsQuestionnairesQuestionOptions($categoryId, $question, $description, $answerSetId, $token);
    }

    /**
     * @param string[] $categoryId List of category Ids
     * @param string $token The Token HTTP request header
     * @return ReadInsightsQuestionnairesQuestionOptions Options builder
     */
    public static function read(array $categoryId = Values::ARRAY_NONE, string $token = Values::NONE): ReadInsightsQuestionnairesQuestionOptions {
        return new ReadInsightsQuestionnairesQuestionOptions($categoryId, $token);
    }

    /**
     * @param string $token The Token HTTP request header
     * @return DeleteInsightsQuestionnairesQuestionOptions Options builder
     */
    public static function delete(string $token = Values::NONE): DeleteInsightsQuestionnairesQuestionOptions {
        return new DeleteInsightsQuestionnairesQuestionOptions($token);
    }
}

class CreateInsightsQuestionnairesQuestionOptions extends Options {
    /**
     * @param string $token The Token HTTP request header
     */
    public function __construct(string $token = Values::NONE) {
        $this->options['token'] = $token;
    }

    /**
     * The Token HTTP request header
     *
     * @param string $token The Token HTTP request header
     * @return $this Fluent Builder
     */
    public function setToken(string $token): self {
        $this->options['token'] = $token;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.CreateInsightsQuestionnairesQuestionOptions ' . $options . ']';
    }
}

class UpdateInsightsQuestionnairesQuestionOptions extends Options {
    /**
     * @param string $categoryId Category ID
     * @param string $question The question.
     * @param string $description The question description.
     * @param string $answerSetId The answer_set for question.
     * @param string $token The Token HTTP request header
     */
    public function __construct(string $categoryId = Values::NONE, string $question = Values::NONE, string $description = Values::NONE, string $answerSetId = Values::NONE, string $token = Values::NONE) {
        $this->options['categoryId'] = $categoryId;
        $this->options['question'] = $question;
        $this->options['description'] = $description;
        $this->options['answerSetId'] = $answerSetId;
        $this->options['token'] = $token;
    }

    /**
     * The ID of the category
     *
     * @param string $categoryId Category ID
     * @return $this Fluent Builder
     */
    public function setCategoryId(string $categoryId): self {
        $this->options['categoryId'] = $categoryId;
        return $this;
    }

    /**
     * The question.
     *
     * @param string $question The question.
     * @return $this Fluent Builder
     */
    public function setQuestion(string $question): self {
        $this->options['question'] = $question;
        return $this;
    }

    /**
     * The description for the question.
     *
     * @param string $description The question description.
     * @return $this Fluent Builder
     */
    public function setDescription(string $description): self {
        $this->options['description'] = $description;
        return $this;
    }

    /**
     * The answer_set for the question.
     *
     * @param string $answerSetId The answer_set for question.
     * @return $this Fluent Builder
     */
    public function setAnswerSetId(string $answerSetId): self {
        $this->options['answerSetId'] = $answerSetId;
        return $this;
    }

    /**
     * The Token HTTP request header
     *
     * @param string $token The Token HTTP request header
     * @return $this Fluent Builder
     */
    public function setToken(string $token): self {
        $this->options['token'] = $token;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.UpdateInsightsQuestionnairesQuestionOptions ' . $options . ']';
    }
}

class ReadInsightsQuestionnairesQuestionOptions extends Options {
    /**
     * @param string[] $categoryId List of category Ids
     * @param string $token The Token HTTP request header
     */
    public function __construct(array $categoryId = Values::ARRAY_NONE, string $token = Values::NONE) {
        $this->options['categoryId'] = $categoryId;
        $this->options['token'] = $token;
    }

    /**
     * The list of category IDs
     *
     * @param string[] $categoryId List of category Ids
     * @return $this Fluent Builder
     */
    public function setCategoryId(array $categoryId): self {
        $this->options['categoryId'] = $categoryId;
        return $this;
    }

    /**
     * The Token HTTP request header
     *
     * @param string $token The Token HTTP request header
     * @return $this Fluent Builder
     */
    public function setToken(string $token): self {
        $this->options['token'] = $token;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.ReadInsightsQuestionnairesQuestionOptions ' . $options . ']';
    }
}

class DeleteInsightsQuestionnairesQuestionOptions extends Options {
    /**
     * @param string $token The Token HTTP request header
     */
    public function __construct(string $token = Values::NONE) {
        $this->options['token'] = $token;
    }

    /**
     * The Token HTTP request header
     *
     * @param string $token The Token HTTP request header
     * @return $this Fluent Builder
     */
    public function setToken(string $token): self {
        $this->options['token'] = $token;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.DeleteInsightsQuestionnairesQuestionOptions ' . $options . ']';
    }
}