<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Oauth\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;

/**
 * @property string $deviceCode
 * @property string $userCode
 * @property string $verificationUri
 * @property string $verificationUriComplete
 * @property string $expiresIn
 * @property int $interval
 */
class DeviceCodeInstance extends InstanceResource {
    /**
     * Initialize the DeviceCodeInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     */
    public function __construct(Version $version, array $payload) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'deviceCode' => Values::array_get($payload, 'device_code'),
            'userCode' => Values::array_get($payload, 'user_code'),
            'verificationUri' => Values::array_get($payload, 'verification_uri'),
            'verificationUriComplete' => Values::array_get($payload, 'verification_uri_complete'),
            'expiresIn' => Values::array_get($payload, 'expires_in'),
            'interval' => Values::array_get($payload, 'interval'),
        ];

        $this->solution = [];
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name) {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Oauth.V1.DeviceCodeInstance]';
    }
}