<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Insights\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Rest\Insights\V1\Call\AnnotationList;
use Twilio\Rest\Insights\V1\Call\CallSummaryList;
use Twilio\Rest\Insights\V1\Call\EventList;
use Twilio\Rest\Insights\V1\Call\MetricList;
use Twilio\Values;
use Twilio\Version;

/**
 * @property string $sid
 * @property string $url
 * @property array $links
 */
class CallInstance extends InstanceResource {
    protected $_events;
    protected $_metrics;
    protected $_summary;
    protected $_annotation;

    /**
     * Initialize the CallInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $sid The sid
     */
    public function __construct(Version $version, array $payload, string $sid = null) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'sid' => Values::array_get($payload, 'sid'),
            'url' => Values::array_get($payload, 'url'),
            'links' => Values::array_get($payload, 'links'),
        ];

        $this->solution = ['sid' => $sid ?: $this->properties['sid'], ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return CallContext Context for this CallInstance
     */
    protected function proxy(): CallContext {
        if (!$this->context) {
            $this->context = new CallContext($this->version, $this->solution['sid']);
        }

        return $this->context;
    }

    /**
     * Fetch the CallInstance
     *
     * @return CallInstance Fetched CallInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): CallInstance {
        return $this->proxy()->fetch();
    }

    /**
     * Access the events
     */
    protected function getEvents(): EventList {
        return $this->proxy()->events;
    }

    /**
     * Access the metrics
     */
    protected function getMetrics(): MetricList {
        return $this->proxy()->metrics;
    }

    /**
     * Access the summary
     */
    protected function getSummary(): CallSummaryList {
        return $this->proxy()->summary;
    }

    /**
     * Access the annotation
     */
    protected function getAnnotation(): AnnotationList {
        return $this->proxy()->annotation;
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name) {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Insights.V1.CallInstance ' . \implode(' ', $context) . ']';
    }
}