<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Microvisor\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class DeviceOptions {
    /**
     * @param string $uniqueName A unique, developer-assigned name for this Device.
     * @param string $targetApp The target App SID or unique name.
     * @param bool $loggingEnabled Whether to enable logging.
     * @return UpdateDeviceOptions Options builder
     */
    public static function update(string $uniqueName = Values::NONE, string $targetApp = Values::NONE, bool $loggingEnabled = Values::NONE): UpdateDeviceOptions {
        return new UpdateDeviceOptions($uniqueName, $targetApp, $loggingEnabled);
    }
}

class UpdateDeviceOptions extends Options {
    /**
     * @param string $uniqueName A unique, developer-assigned name for this Device.
     * @param string $targetApp The target App SID or unique name.
     * @param bool $loggingEnabled Whether to enable logging.
     */
    public function __construct(string $uniqueName = Values::NONE, string $targetApp = Values::NONE, bool $loggingEnabled = Values::NONE) {
        $this->options['uniqueName'] = $uniqueName;
        $this->options['targetApp'] = $targetApp;
        $this->options['loggingEnabled'] = $loggingEnabled;
    }

    /**
     * A unique and addressable name to be assigned to this Device by the developer. It may be used in place of the Device SID.
     *
     * @param string $uniqueName A unique, developer-assigned name for this Device.
     * @return $this Fluent Builder
     */
    public function setUniqueName(string $uniqueName): self {
        $this->options['uniqueName'] = $uniqueName;
        return $this;
    }

    /**
     * The SID or unique name of the App to be targeted to the Device.
     *
     * @param string $targetApp The target App SID or unique name.
     * @return $this Fluent Builder
     */
    public function setTargetApp(string $targetApp): self {
        $this->options['targetApp'] = $targetApp;
        return $this;
    }

    /**
     * A Boolean flag specifying whether to enable application logging. Logs will be enabled or extended for 24 hours.
     *
     * @param bool $loggingEnabled Whether to enable logging.
     * @return $this Fluent Builder
     */
    public function setLoggingEnabled(bool $loggingEnabled): self {
        $this->options['loggingEnabled'] = $loggingEnabled;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Microvisor.V1.UpdateDeviceOptions ' . $options . ']';
    }
}